<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

$apiVersion = env('api_version', 'v1');
$routes->group("api/$apiVersion", function($routes) {
$routes->get('dashboard/summary', 'DashboardController::summary', ['filter' => 'auth']);

    $routes->post('auth/login', 'UsersController::login');
    $routes->post('auth/logout', 'UsersController::logout');
    $routes->get('auth/status', 'UsersController::status', ['filter' => 'auth']);

    $routes->resource('users', ['controller' => 'UsersController', 'filter' => ['auth', 'admin']]);

    $routes->get('tests/count', 'TestsController::count', ['filter' => 'auth']);
    $routes->resource('tests', ['controller' => 'TestsController', 'filter' => 'auth']);

    $routes->get('patients/count', 'PatientsController::count', ['filter' => 'auth']);
    $routes->get('patients/search', 'PatientsController::getPatientByNameOrPhone', ['filter' => 'auth']);
    $routes->get('patients/{patientId}/invoices', 'InvoicesController::getInvoiceByPatientId', ['filter' => 'auth']);
    $routes->get('patients/(:num)/reports', 'ReportsController::getReportsByPatientId/$1', ['filter' => 'auth']);
    $routes->resource('patients', ['controller' => 'PatientsController', 'filter' => 'auth']);

    $routes->get('invoices/count', 'InvoicesController::count', ['filter' => 'auth']);
    $routes->get('invoices/tests-count', 'InvoicesController::countTests', ['filter' => 'auth']);
    $routes->get('invoices/patient-invoices', 'InvoicesController::getInvoicesByPatientId', ['filter' => 'auth']);
    $routes->get('invoices/search', 'InvoicesController::getInvoiceByLabNumber', ['filter' => 'auth']);
    $routes->get('invoices/invoice-tests/search-by-status', 'InvoicesController::getInvoicesTestsByStatus', ['filter' => 'auth']);
    $routes->get('invoices/invoice-tests/(:num)', 'InvoicesController::getInvoiceTestById/$1', ['filter' => 'auth']);
    $routes->resource('invoices', ['controller' => 'InvoicesController', 'filter' => 'auth']);

    $routes->resource('reports', ['controller' => 'ReportsController', 'filter' => 'auth']);

    $routes->resource('utilities', ['controller' => 'UtilitiesController', 'filter' => 'auth']);
});

$routes->get('/', 'Home::index');
// $routes->get('(:any)', 'Home::index');
$routes->get('^((?!api|assets|js|css|images).)*$', 'Home::index');

