<?php

namespace App\Models;

use CodeIgniter\Model;

class PatientModel extends Model
{
    protected $table            = 'patients';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['name', 'age', 'sex', 'phone'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
        'id'    => 'permit_empty|integer',
        'name'  => 'required|trim|min_length[3]|max_length[100]',
        'age'   => 'permit_empty|integer|greater_than_equal_to[0]',
        'sex'   => 'in_list[Male,Female]',
        'phone' => 'permit_empty|regex_match[/^(03\d{9}|\+923\d{9})$/]|is_unique[patients.phone,id,{id}]',
    ];
    protected $validationMessages   = [
        'name' => [
            'required'    => 'Name is required.',
            'alpha_space' => 'Name can only contain alphabetic characters and spaces.',
            'min_length'  => 'Name must be at least 3 characters long.',
            'max_length'  => 'Name cannot exceed 100 characters.',
        ],
        'age' => [
            'integer'                   => 'Age must be an integer.',
            'greater_than_equal_to'     => 'Age must be 0 or greater.',
        ],
        'sex' => [
            'in_list' => 'Sex must be either Male or Female.',
        ],
        'phone' => [
            'required'      => 'Phone number is required.',
            'regex_match'   => 'Phone number must be a valid format.',
            'is_unique'     => 'Phone number must be unique.',
        ],
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
