<?php

namespace App\Models;

use CodeIgniter\Model;

class TestItemModel extends Model
{
    protected $table            = 'test_items';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['test_id', 'name', 'unit', 'normal_value'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    // protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
        'test_id'      => 'required|integer|checkTestExists',
        'name'         => 'required|max_length[50]',
        'unit'         => 'permit_empty|max_length[10]',
        'normal_value' => 'permit_empty|max_length[20]',
    ];
    protected $validationMessages   = [
        'test_id' => [
            'required' => 'Test ID is required.',
            'integer'  => 'Test ID must be an integer.',
            'checkTestExists' => 'The specified test does not exist.',
        ],
        'name' => [
            'required'    => 'Name is required.',
            'max_length'  => 'Name cannot exceed 50 characters.',
        ],
        'unit' => [
            'required'    => 'Unit is required.',
            'max_length'  => 'Unit cannot exceed 10 characters.',
        ],
        'normal_value' => [
            'required'    => 'Normal value is required.',
            'max_length'  => 'Normal value cannot exceed 20 characters.',
        ],
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
