<?php

namespace App\Validation;

use CodeIgniter\Database\BaseConnection;

class TestRules
{
    public static function checkTestExists($str, ?string $fields = null, array $data = [], ?BaseConnection &$db = null): bool
    {
        $db = $db ?? \Config\Database::connect();
        return $db->table('tests')->where('id', $str)->countAllResults() > 0;
    }

    public static function checkTestItemExists($str, ?string $fields = null, array $data = [], ?BaseConnection &$db = null): bool
    {
        $db = $db ?? \Config\Database::connect();
        return $db->table('test_items')->where('id', $str)->countAllResults() > 0;
    }
}
